/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.tools.recipies;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.ftbsbc.tools.recipies.CrookRecipe;
import dev.ftb.ftbsbc.tools.recipies.ItemWithChance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CrookRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<CrookRecipe> {
    public CrookRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        CrookRecipe r = new CrookRecipe(recipeId, json.has("group") ? json.get("group").getAsString() : "");
        r.max = GsonHelper.m_13824_((JsonObject)json, (String)"max", (int)0);
        r.ingredient = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredient")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
        for (JsonElement e : json.get("results").getAsJsonArray()) {
            JsonObject o = e.getAsJsonObject();
            r.results.add(new ItemWithChance(ShapedRecipe.m_151274_((JsonObject)o), o.has("chance") ? o.get("chance").getAsDouble() : 1.0));
        }
        return r;
    }

    public CrookRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        CrookRecipe r = new CrookRecipe(recipeId, buffer.m_130136_(Short.MAX_VALUE));
        r.ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        r.max = buffer.m_130242_();
        int w = buffer.m_130242_();
        for (int i = 0; i < w; ++i) {
            r.results.add(new ItemWithChance(buffer.m_130267_(), buffer.readDouble()));
        }
        return r;
    }

    public void toNetwork(FriendlyByteBuf buffer, CrookRecipe r) {
        buffer.m_130072_(r.m_6076_(), Short.MAX_VALUE);
        r.ingredient.m_43923_(buffer);
        buffer.m_130130_(r.max);
        buffer.m_130130_(r.results.size());
        for (ItemWithChance i : r.results) {
            buffer.m_130055_(i.item());
            buffer.writeDouble(i.chance());
        }
    }
}

